/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.races.goblin;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.client.gui.entityPropertiesGui.GuiEntityProperties;
import xzeroair.trinkets.client.gui.hud.mana.ManaHud;
import xzeroair.trinkets.client.model.GoblinEars;
import xzeroair.trinkets.entity.AlphaWolf;
import xzeroair.trinkets.init.EntityRaces;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.races.EntityRacePropertiesHandler;
import xzeroair.trinkets.races.goblin.config.GoblinConfig;
import xzeroair.trinkets.traits.abilities.AbilityClimbing;
import xzeroair.trinkets.traits.abilities.other.AbilityWolfMount;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.helpers.ColorHelper;
import xzeroair.trinkets.util.helpers.DrawingHelper;

public class RaceGoblin
extends EntityRacePropertiesHandler {
    public static final GoblinConfig serverConfig = TrinketsConfig.SERVER.races.goblin;
    private final ModelBase ears = new GoblinEars();
    public static final ResourceLocation TEXTURE = new ResourceLocation("xat:textures/ears.png");
    public static final ResourceLocation TEXTURE_INNER = new ResourceLocation("xat:textures/inner_ears.png");
    public static final ResourceLocation TEXTURE_OUTER = new ResourceLocation("xat:textures/outer_ears.png");

    public RaceGoblin(@Nonnull EntityLivingBase e) {
        super(e, EntityRaces.goblin);
    }

    @Override
    public void startTransformation() {
        this.addAbility(new AbilityClimbing());
        this.addAbility(new AbilityWolfMount());
    }

    @Override
    public void whileTransformed() {
    }

    @Override
    public void targetedByEnemy(EntityLivingBase enemy) {
        if (RaceGoblin.serverConfig.friendly_creepers && enemy instanceof EntityCreeper) {
            ((EntityCreeper)enemy).func_70624_b(null);
        }
    }

    @Override
    public float isHurt(DamageSource source, float dmg) {
        if (source.func_94541_c() && !TrinketHelper.AccessoryCheck(this.entity, ModItems.trinkets.TrinketDamageShield)) {
            float maxHP = this.entity.func_110143_aJ();
            float modifier = maxHP * 100.0f / 20.0f * 0.01f;
            float clampModifier = MathHelper.func_76131_a((float)modifier, (float)0.01f, (float)1.0f);
            return dmg * clampModifier;
        }
        if (source.func_76347_k()) {
            float modifier = 0.8f;
            if (source.func_76355_l().equalsIgnoreCase("Lava")) {
                modifier = 0.5f;
            }
            return dmg * modifier;
        }
        return dmg;
    }

    @Override
    public boolean attackedEntity(EntityLivingBase target, DamageSource source, float dmg) {
        boolean attack = super.attackedEntity(target, source, dmg);
        if (RaceGoblin.serverConfig.creepers_explode && attack && target instanceof EntityCreeper) {
            if (!((EntityCreeper)target).func_146078_ca()) {
                ((EntityCreeper)target).func_146079_cb();
            }
            if (((EntityCreeper)target).func_70832_p() == -1) {
                ((EntityCreeper)target).func_70829_a(1);
            }
        }
        return attack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void doRenderLayer(RenderLivingBase renderer, boolean isFake, boolean isSlim, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!TrinketsConfig.CLIENT.rendering) {
            return;
        }
        if (this.showTraits()) {
            GlStateManager.func_179094_E();
            if (this.entity.func_70093_af()) {
                GlStateManager.func_179137_b((double)0.0, (double)0.2, (double)0.0);
            }
            if (renderer instanceof RenderPlayer) {
                RenderPlayer rend = (RenderPlayer)renderer;
                rend.func_177087_b().field_78116_c.func_78794_c(scale);
            }
            if (this.entity.func_190630_a(EntityEquipmentSlot.HEAD)) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.02f, (float)-0.045f);
                GlStateManager.func_179152_a((float)1.1f, (float)1.1f, (float)1.1f);
            }
            float[] rgb = ColorHelper.getRGBColor(this.getTraitVariant() == 1 ? this.getAltTraitColor() : this.getTraitColor());
            float[] rgb2 = ColorHelper.getRGBColor(this.getTraitVariant() == 1 ? this.getTraitColor() : this.getAltTraitColor());
            float fscale = 0.34f;
            GlStateManager.func_179152_a((float)0.34f, (float)0.34f, (float)0.34f);
            double x = 0.0;
            double y = -1.2;
            double z = -0.6;
            double height = 1.0;
            double width = 1.0;
            float u = 0.0f;
            float v = 0.0f;
            int uWidth = 16;
            int vHeight = 16;
            float tileWidth = 64.0f;
            float tileHeight = 32.0f;
            double xR = 0.5;
            double xL = -0.5;
            float rot = 30.0f;
            int solidVariant = 2;
            GlStateManager.func_179140_f();
            GlStateManager.func_179129_p();
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)(-rot), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            if (this.getTraitVariant() == 2) {
                DrawingHelper.Draw(TEXTURE, 0.5, -1.2, -0.6, 0.0f, 0.0f, 16, 16, 1.0, 1.0, 64.0f, 32.0f, rgb[0], rgb[1], rgb[2], 1.0f);
                DrawingHelper.Draw(TEXTURE, 0.5, -1.2, -0.5999, 0.0f, 16.0f, 16, 16, 1.0, 1.0, 64.0f, 32.0f, rgb[0], rgb[1], rgb[2], 1.0f);
            } else {
                DrawingHelper.Draw(TEXTURE_INNER, 0.5, -1.2, -0.6, 0.0f, 0.0f, 16, 16, 1.0, 1.0, 64.0f, 32.0f, rgb[0], rgb[1], rgb[2], 1.0f);
                DrawingHelper.Draw(TEXTURE_OUTER, 0.5, -1.2, -0.6, 0.0f, 0.0f, 16, 16, 1.0, 1.0, 64.0f, 32.0f, rgb2[0], rgb2[1], rgb2[2], 1.0f);
                DrawingHelper.Draw(TEXTURE_OUTER, 0.5, -1.2, -0.5999, 0.0f, 16.0f, 16, 16, 1.0, 1.0, 64.0f, 32.0f, rgb2[0], rgb2[1], rgb2[2], 1.0f);
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            if (this.getTraitVariant() == 2) {
                DrawingHelper.Draw(TEXTURE, -0.5, -1.2, -0.6, 0.0f, 0.0f, 16, 16, -1.0, 1.0, 64.0f, 32.0f, rgb[0], rgb[1], rgb[2], 1.0f);
                DrawingHelper.Draw(TEXTURE, -0.5, -1.2, -0.5999, 0.0f, 16.0f, 16, 16, -1.0, 1.0, 64.0f, 32.0f, rgb[0], rgb[1], rgb[2], 1.0f);
            } else {
                DrawingHelper.Draw(TEXTURE_INNER, -0.5, -1.2, -0.6, 0.0f, 0.0f, 16, 16, -1.0, 1.0, 64.0f, 32.0f, rgb[0], rgb[1], rgb[2], 1.0f);
                DrawingHelper.Draw(TEXTURE_OUTER, -0.5, -1.2, -0.6, 0.0f, 0.0f, 16, 16, -1.0, 1.0, 64.0f, 32.0f, rgb2[0], rgb2[1], rgb2[2], 1.0f);
                DrawingHelper.Draw(TEXTURE_OUTER, -0.5, -1.2, -0.5999, 0.0f, 16.0f, 16, 16, -1.0, 1.0, 64.0f, 32.0f, rgb2[0], rgb2[1], rgb2[2], 1.0f);
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179145_e();
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void doRenderPlayerPre(EntityPlayer entity, double x, double y, double z, RenderPlayer renderer, float partialTick) {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (!(entity != Minecraft.func_71410_x().field_71439_g || screen == null || screen instanceof GuiChat || screen instanceof GuiEntityProperties || screen instanceof ManaHud)) {
            return;
        }
        if ((this.isTransforming() || this.isTransformed()) && !this.properties.isNormalSize()) {
            double hScale = (double)this.properties.getHeightValue() * 0.01;
            double wScale = (double)this.properties.getWidthValue() * 0.01;
            double xLoc = x / wScale - x;
            double yLoc = y / hScale - y;
            double zLoc = z / wScale - z;
            double yOffset = entity.func_70033_W();
            Entity mount = entity.func_184187_bx();
            double mountedOffset = entity.func_184218_aH() && mount != null ? mount.func_70042_X() : 0.0;
            double retMountedOffset = -(mountedOffset + yOffset) - 0.1;
            if (entity.func_184218_aH() && !(mount instanceof AlphaWolf)) {
                GlStateManager.func_179137_b((double)0.0, (double)mountedOffset, (double)0.0);
                GlStateManager.func_179137_b((double)0.0, (double)(-yOffset), (double)0.0);
                GlStateManager.func_179137_b((double)0.0, (double)retMountedOffset, (double)0.0);
            }
            GlStateManager.func_179139_a((double)wScale, (double)hScale, (double)wScale);
            if (entity.func_184218_aH() && !(mount instanceof AlphaWolf)) {
                GlStateManager.func_179137_b((double)0.0, (double)(-retMountedOffset), (double)0.0);
                GlStateManager.func_179137_b((double)0.0, (double)yOffset, (double)0.0);
                GlStateManager.func_179137_b((double)0.0, (double)(-mountedOffset), (double)0.0);
            }
            GlStateManager.func_179137_b((double)xLoc, (double)yLoc, (double)zLoc);
        }
    }
}

